//$fn=16;
$fn=8*16;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;
$support = 0.05;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

$inset_height=4;
$inset_radius=15.5;

$center_height = 10;
$center_width = 10;
$swallow_size = 2;
$swallow_d = 0.5;
$swallow_count = 7;
$swallow_frac = 0.2;
$swallow_clearance = 0.05;

$tool_inner_radius = 1.5;
$tool_outer_radius = 1.75;
$tool_brace_height = 2;
$tool_screw_size = 0.3;

$joint_master_radius = 2.75;
$joint_handle_radius = 1.75;
$joint_split_radius  = 2.5;
$joint_split_outside = 3;
$joint_height = 1;
$joint_nook_depth = 0.2;
$joint_radius_diff = 0.25;

module click_inner(clearance, radius)
{
    difference()
    {
        cylinder(h=$joint_height,r=$joint_radius_diff+radius+clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+$delta,r=radius-clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius - $joint_nook_depth/2, $joint_height/2])  
            cube(size=[$joint_nook_depth + 2*clearance, $joint_nook_depth + 2*clearance, $joint_height], center=true);

        intersection()
        {
            difference()
            {
                cylinder(h=$joint_nook_depth,r=radius+clearance);
                
                translate([0,0,$delta/-2])    
                    cylinder(h=$joint_nook_depth + $delta,r=radius-$joint_nook_depth-clearance);                
            }       
        
            linear_extrude(height=$joint_nook_depth+$delta) polygon(points=[
                [0, 0],
                [$joint_radius_diff+radius, 0],
                [$joint_radius_diff+radius, $joint_radius_diff+radius],
            ]);
        }
    }
    
}

module click_outer(clearance, extend, radius)
{
    difference()
    {
        cylinder(h=$joint_height+extend,r=$joint_radius_diff+radius-clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+extend+$delta,r=radius+clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius + clearance - $joint_nook_depth/2, $joint_nook_depth/2])  
            cube(size=[$joint_nook_depth, $joint_nook_depth , $joint_nook_depth], center=true);       
    }
    
}

$handle_outside = 3.5;
$handle_outside_small = 2.2;
$handle_diamond = 4;
$handle_inside = 1.25; //(2.8 / 2) /*+ $swallow_clearance*/;
$handle_segment = 10;
$handle_diamond_width = 0.2;

union()
{    
    translate([0,0,$joint_height+$handle_segment])
        rotate(180, [0,1,0])
        click_outer($swallow_clearance, $swallow_clearance, $joint_split_radius);
    
    difference()
    {        
        cylinder(h=($handle_segment-$swallow_clearance)/2, r=$joint_split_outside, r2=$handle_diamond);
        cylinder(h=($handle_segment-$swallow_clearance)/2, r=$handle_outside_small+$swallow_clearance, r2=$handle_diamond-$handle_diamond_width);
        
    }
    
    translate([0,0,($handle_segment-$swallow_clearance)/2])
    difference()
    {        
        cylinder(h=($handle_segment-$swallow_clearance)/2, r2=$joint_split_outside, r=$handle_diamond);
        cylinder(h=($handle_segment-$swallow_clearance)/2, r2=$handle_outside_small+$swallow_clearance, r=$handle_diamond-$handle_diamond_width);
        
    }
}
 