//$fn=16;
$fn=8*16;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;
$support = 0.05;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

$inset_height=4;
$inset_radius=15.5;

$center_height = 10;
$center_width = 10;
$swallow_size = 2;
$swallow_d = 0.5;
$swallow_count = 7;
$swallow_frac = 0.2;
$swallow_clearance = 0.05;

$tool_inner_radius = 1.5;
$tool_outer_radius = 1.75;
$tool_brace_height = 2;
$tool_screw_size = 0.3;

$joint_master_radius = 2.75;
$joint_handle_radius = 1.75;
$joint_height = 1;
$joint_nook_depth = 0.2;
$joint_radius_diff = 0.25;

$joint_split_radius  = 2.5;
$joint_split_outside = 3;

module click_inner(clearance, radius)
{
    difference()
    {
        cylinder(h=$joint_height,r=$joint_radius_diff+radius+clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+$delta,r=radius-clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius - $joint_nook_depth/2, $joint_height/2])  
            cube(size=[$joint_nook_depth + 2*clearance, $joint_nook_depth + 2*clearance, $joint_height], center=true);

        intersection()
        {
            difference()
            {
                cylinder(h=$joint_nook_depth,r=radius+clearance);
                
                translate([0,0,$delta/-2])    
                    cylinder(h=$joint_nook_depth + $delta,r=radius-$joint_nook_depth-clearance);                
            }       
        
            linear_extrude(height=$joint_nook_depth+$delta) polygon(points=[
                [0, 0],
                [$joint_radius_diff+radius, 0],
                [$joint_radius_diff+radius, $joint_radius_diff+radius],
            ]);
        }
    }
    
}

module click_outer(clearance, extend, radius)
{
    difference()
    {
        cylinder(h=$joint_height+extend,r=$joint_radius_diff+radius-clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+extend+$delta,r=radius+clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius + clearance - $joint_nook_depth/2, $joint_nook_depth/2])  
            cube(size=[$joint_nook_depth, $joint_nook_depth , $joint_nook_depth], center=true);       
    }
    
}

$handle_outside = 3.5;
$handle_outside_small = 2.2;
$handle_inside = 1.25; //(2.8 / 2) /*+ $swallow_clearance*/;
$handle_segment = 16;
$handle_closer = 2.5;

$diamond_width = 2.25;
$diamond_break = 0.5;
$diamond_depth = 1.5;
$diamond_shear = 4;
$diamond_notch_height = 0.1;
$diamond_notch_depth = 0.5;

$diamond_mid = $handle_segment / 2 - 0.25;
$diamond_top = $handle_segment - $diamond_mid;
$diamond_overshear = $diamond_shear * ($diamond_top / $diamond_mid);

$interlock_w = 1;
$interlock_h = 2;
$interlock_d = 0.5;

module diamond_point(height, shear, clearance)
{
    notch_side = $diamond_width - ($diamond_break + clearance);
    notch_front = $diamond_depth * (($diamond_break+clearance)/$diamond_width);
    notch_side_m = notch_side - $diamond_notch_depth - clearance;
    
    multmatrix(m=[
        [1,0,0,0],
        [0,1,shear/height,0],
        [0,0,1,0],
        [0,0,0,1]
    ])
    linear_extrude(height=height, center=false)
        polygon(points=[
            [$diamond_depth,0],
            [0, $diamond_width],
            [-$diamond_depth, 0],
            [-notch_front, -notch_side],
            [-$diamond_notch_height - clearance, -notch_side],
            [-$diamond_notch_height - clearance, -notch_side_m],
            [$diamond_notch_height + clearance, -notch_side_m],
            [$diamond_notch_height + clearance, -notch_side],
            [notch_front, -notch_side]
        ]);
}

module interlock(clearance)
{
    for($u = [-.5,.5]) for($v = [.5, 1.5])
        translate([0,$u*$diamond_shear,$v*$diamond_mid])
            multmatrix([
                [1,0,-0.5,0],
                [0,1,0,0],
                [0,0,1,0],
                [0,0,0,1]
            ])
                cube(size=[$interlock_d-clearance,$interlock_w-clearance,$interlock_h-clearance], center=true);
    
    
}

intersection()
{
  union()
  {    
    translate([0,0,$joint_height+$handle_segment])
        rotate(180, [0,1,0])
        click_outer($swallow_clearance, $swallow_clearance, $joint_handle_radius);
      
    translate([0,0,$joint_height+$handle_segment])
        rotate(180, [0,1,0])
            click_outer($swallow_clearance, $swallow_clearance, $joint_split_radius);
      
    difference()
    {        
        union()
        {
            translate([0,0,$handle_segment-$handle_closer])
                cylinder(h=$handle_closer-$swallow_clearance, r=0.5, r2=$joint_split_outside);
            
             diamond_point($diamond_mid, $diamond_shear, $swallow_clearance);
            
            
            translate([0,$diamond_shear,$diamond_mid])
            diamond_point($diamond_top, -$diamond_overshear, $swallow_clearance);
            
            rotate(180, [0,0,1])
            diamond_point($diamond_mid, $diamond_shear, $swallow_clearance);
            
            rotate(180, [0,0,1])
            translate([0,$diamond_shear,$diamond_mid])
            diamond_point($diamond_top, -$diamond_overshear, $swallow_clearance);       
            
        }
            
        union()
        {
            translate([0,0,-$swallow_clearance+$handle_segment - $handle_closer/2])
            cylinder(h=$handle_segment+2*$swallow_clearance, r=$handle_inside);          
            
            // for female end
            rotate(180, [0,0,1]) interlock(-$swallow_clearance);
        }
    }    
  }
  union()
  {
    translate([0,-50,0]) cube(size=[100,100,100], center=false);
      
    // for male end
    //interlock($swallow_clearance);
  }
}

// manual support tricks
/*
for ($u = [-1,1])
    translate([$diamond_shear/-2 + $interlock_d,$u*$diamond_shear,$diamond_mid/2])
        multmatrix([
            [1,0,$diamond_shear/$diamond_mid,0],
            [0,1,0,0],
            [0,0,1,0],
            [0,0,0,1]
        ])
            cube(size=[$interlock_d/4, $interlock_h, $diamond_mid], center=true);
*/
 
// detach support for support
/*
for ($u = [-1,1])
    translate([0,$u*$diamond_shear, $swallow_clearance])
        cube(size=[2*$interlock_d+$swallow_clearance,$interlock_h+$swallow_clearance,2*$swallow_clearance], center=true);
*/

// detach support for interlock

/*
for ($u = [-.5,.5])
    translate([$interlock_h/-4 - 2* $swallow_clearance,$u*$diamond_shear, $swallow_clearance])
        cube(size=[$interlock_h/2+$swallow_clearance,$interlock_h+$swallow_clearance,2*$swallow_clearance], center=true);
*/

// detach support for twistlock
/*
translate([$diamond_depth + ($handle_outside_small - $diamond_depth)/2 + $swallow_clearance, 0, $swallow_clearance])
    cube([$handle_outside_small - $diamond_depth, 2*$handle_outside_small, 2 * $swallow_clearance], center=true);
*/