//$fn=16;
$fn=8*16;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;
$support = 0.05;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

$inset_height=4;
$inset_radius=15.5;

$center_height = 10;
$center_width = 10;
$swallow_size = 2;
$swallow_d = 0.5;
$swallow_count = 7;
$swallow_frac = 0.2;
$swallow_clearance = 0.05;

$tool_inner_radius = 1.5;
$tool_outer_radius = 1.75;
$tool_brace_height = 2;
$tool_screw_size = 0.3;

$joint_master_radius = 2.75;
$joint_handle_radius = 1.75;
$joint_height = 1;
$joint_nook_depth = 0.2;
$joint_radius_diff = 0.25;

module click_inner(clearance, radius)
{
    difference()
    {
        cylinder(h=$joint_height,r=$joint_radius_diff+radius+clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+$delta,r=radius-clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius - $joint_nook_depth/2, $joint_height/2])  
            cube(size=[$joint_nook_depth + 2*clearance, $joint_nook_depth + 2*clearance, $joint_height], center=true);

        intersection()
        {
            difference()
            {
                cylinder(h=$joint_nook_depth,r=radius+clearance);
                
                translate([0,0,$delta/-2])    
                    cylinder(h=$joint_nook_depth + $delta,r=radius-$joint_nook_depth-clearance);                
            }       
        
            linear_extrude(height=$joint_nook_depth+$delta) polygon(points=[
                [0, 0],
                [$joint_radius_diff+radius, 0],
                [$joint_radius_diff+radius, $joint_radius_diff+radius],
            ]);
        }
    }
    
}

module click_outer(clearance, extend, radius)
{
    difference()
    {
        cylinder(h=$joint_height+extend,r=$joint_radius_diff+radius-clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+extend+$delta,r=radius+clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius + clearance - $joint_nook_depth/2, $joint_nook_depth/2])  
            cube(size=[$joint_nook_depth, $joint_nook_depth , $joint_nook_depth], center=true);       
    }
    
}

$handle_outside = 3.5;
$handle_outside_small = 2.2;
$handle_inside = 1.25; //(2.8 / 2) /*+ $swallow_clearance*/;
$handle_segment = 16;
$handle_closer = 2.5;

$diamond_width = 2.25;
$diamond_break = 0.5;
$diamond_depth = 1.5;
$diamond_shear = 4;
$diamond_notch_height = 0.1;
$diamond_notch_depth = 0.5;

$diamond_mid = $handle_segment / 2 - 0.25;
$diamond_top = $handle_segment - $diamond_mid;
$diamond_overshear = $diamond_shear * ($diamond_top / $diamond_mid);

$interlock_w = 1;
$interlock_h = 2;
$interlock_d = 0.2;

$pommel_crystal_base_height = $diamond_depth * $diamond_break / $diamond_width;

module diamond_point(height, shear, clearance)
{
    notch_side = $diamond_width - ($diamond_break + clearance);
    notch_front = $diamond_depth * (($diamond_break+clearance)/$diamond_width);
    notch_side_m = notch_side - $diamond_notch_depth - clearance;
    
    multmatrix(m=[
        [1,0,0,0],
        [0,1,shear/height,0],
        [0,0,1,0],
        [0,0,0,1]
    ])
    linear_extrude(height=height, center=false)
        polygon(points=[
            [$diamond_depth,0],
            [0, $diamond_width],
            [-$diamond_depth, 0],
            [-notch_front, -notch_side],
            [-$diamond_notch_height - clearance, -notch_side],
            [-$diamond_notch_height - clearance, -notch_side_m],
            [$diamond_notch_height + clearance, -notch_side_m],
            [$diamond_notch_height + clearance, -notch_side],
            [notch_front, -notch_side]
        ]);
}

// the calculated outline dimensions
$pommel_w1 = $diamond_shear - $diamond_width;
$ratio_1 = $pommel_w1 / $diamond_width;
$pommel_h1 = ($ratio_1 * $diamond_mid) / (1 + $ratio_1);

$pommel_w2 = $pommel_w1 + $diamond_break;
$ratio_2 = $pommel_w2 / ($diamond_width - $diamond_break);
$pommel_h2 = ($ratio_2 * $diamond_mid) / (1 + $ratio_2);

$pommel_w3 = $pommel_w2 + $diamond_notch_depth + $swallow_clearance;
$ratio_3 = $pommel_w3 / ($diamond_width - $diamond_break - $diamond_notch_depth - $swallow_clearance);
$pommel_h3 = ($ratio_3 * $diamond_mid) / (1 + $ratio_3);

$pommel_crystal_prominence = ($pommel_w2 - $swallow_clearance) * $diamond_depth / $diamond_width;

/*
linear_extrude(height=3*$diamond_notch_height-$swallow_clearance) 
    polygon(points=[
        [$pommel_w1, 0],
        [0, $pommel_h1],
        [-$pommel_w1, 0],
        [0, -$pommel_h1],
    ]);
    */

linear_extrude(height=$pommel_crystal_base_height) 
    polygon(points=[
        [$pommel_w2+$swallow_clearance, 0],
        [0, $pommel_h2+$swallow_clearance],
        [-$pommel_w2-$swallow_clearance, 0],
        [0, -$pommel_h2-$swallow_clearance],
    ]);
    
linear_extrude(height=$diamond_notch_height-$swallow_clearance) 
    polygon(points=[
        [$pommel_w3+$swallow_clearance, 0],
        [0, $pommel_h3+$swallow_clearance],
        [-$pommel_w3-$swallow_clearance, 0],
        [0, -$pommel_h3-$swallow_clearance],
    ]);
    
translate([0,0,$pommel_crystal_base_height])
    scale([$pommel_w2+$swallow_clearance, $pommel_h2+$swallow_clearance, 1])
        cylinder(h=$pommel_crystal_prominence,r1=1,r2=0,$fn=4);