$fn=8*8;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

module screw(p1) 
{
    difference()
    {
        cube(size=[$floor, $band, $band], center=true);
        rotate(90,[0,1,0]) translate([0,0,$delta/-2]) cylinder(h=$floor + $delta,r=$screw_inside);
        
        rotate(90,[0,1,0]) translate([0,0,$floor/2-$screw_split]) cylinder(h=$floor,r=$screw_outside);
    }
}

intersection()
{
    union() {
        difference()
        {    
            cylinder(h=$height,r=$outside_radius);
            translate([0,0,-0.5*$delta])
                cylinder(h=$height+$delta,r=$inside_radius);
            translate([0,0,$floor])
                cylinder(h=$height,r=$outside_radius-$floor);
        }
        
        for($slot = [0 : 15]) rotate(360/32*(2*$slot+1))
        {
            translate([$inside_radius + $floor/2, 0, $band/2]) screw();
            translate([$outside_radius - $band/2, 0, $height-$floor/2]) rotate(90, [0,1,0]) screw();

            translate([$inside_radius,$band/2,0]) rotate(90, [1,0,0]) linear_extrude(height=$band) polygon(points=[
                [0, $band],
                [$outside_radius-$inside_radius-$band, $height],
                [$outside_radius-$inside_radius-$band, $height-$floor],
                [$floor, $band]
            ]);
                        
        }
        
        for($slot = [0:8]) rotate(360/8*$slot)
        {
            translate([$floor/2,$outside_radius-$band/2,$band/2]) screw();
            translate([$floor/2,-($outside_radius-$band/2),$band/2]) screw();
        }
    }
    
    linear_extrude(height=$height+$delta) polygon(points=[
        [0,0],[$outside_radius+$delta,0],[$outside_radius+$delta,$outside_radius+$delta]
    ]);
}
