$fn=8*8;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;
$support = 0.05;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

$inset_height=4;
$inset_radius=15.5;

$ds_height = 2;
$ds_length = 7.5;
$ds_width  = 1;

module screw(p1) 
{
    difference()
    {
        cube(size=[$floor, $band, $band], center=true);
        rotate(90,[0,1,0]) translate([0,0,$delta/-2]) cylinder(h=$floor + $delta,r=$screw_inside);
        
        rotate(90,[0,1,0]) translate([0,0,$floor/2-$screw_split]) cylinder(h=$floor,r=$screw_outside);
    }
}


union()
{
    translate([0,0, $ds_height-$floor/2]) union() {    
        rotate(90, [0,1,0]) screw();
        translate([($band-$floor)/2, 0, ($ds_height - $floor)/-2])
            cube(size=[$floor, $band, $ds_height], center=true);
        translate([($band-$floor)/-2, 0, ($ds_height - $floor)/-2])
            cube(size=[$floor, $band, $ds_height], center=true);
    }
    translate([($ds_width + $band)/2-$floor ,0,$floor/2])
        cube(size=[$ds_width, $ds_length, $floor], center=true);
    translate([($ds_width + $band)/-2+$floor ,0,$floor/2])
        cube(size=[$ds_width, $ds_length, $floor], center=true);
}