$fn=8*16;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;
$support = 0.05;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

$inset_height=4;
$inset_radius=15.5;

$center_height = 10;
$center_width = 10;
$swallow_size = 2;
$swallow_d = 0.5;
$swallow_count = 7;
$swallow_frac = 0.2;
$swallow_clearance = 0.05;

$tool_inner_radius = 1.5;
$tool_outer_radius = 1.75;
$tool_brace_height = 2;
$tool_screw_size = 0.3;

$joint_inner_radius = 2.75;
$joint_outer_radius = 3;
$joint_height = 1;
$joint_nook_depth = 0.2;

module click_inner(clearance)
{
    difference()
    {
        cylinder(h=$joint_height,r=$joint_outer_radius+clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+$delta,r=$joint_inner_radius-clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, $joint_inner_radius - $joint_nook_depth/2, $joint_height/2])  
            cube(size=[$joint_nook_depth + 2*clearance, $joint_nook_depth + 2*clearance, $joint_height], center=true);

        intersection()
        {
            difference()
            {
                cylinder(h=$joint_nook_depth,r=$joint_inner_radius+clearance);
                
                translate([0,0,$delta/-2])    
                    cylinder(h=$joint_nook_depth + $delta,r=$joint_inner_radius-$joint_nook_depth-clearance);                
            }       
        
            linear_extrude(height=$joint_nook_depth+$delta) polygon(points=[
                [0, 0],
                [$joint_outer_radius, 0],
                [$joint_outer_radius, $joint_outer_radius],
            ]);
        }
    }
    
}

module swallow(clearance, p1)
{
    $swallow_width = $center_height/$swallow_count;
    
    // ->        <-
    //  __________
    //  \    |   /
    //   \   v  /
    // ---\    /-------
    //   ->    <-
    //       
    
    $l_raw_base_off = ($swallow_width/4) * (1-$swallow_frac);
    $l_raw_out_off = ($swallow_width/4) * (1+$swallow_frac);
    $l_base_off = $l_raw_base_off - clearance;
    $l_out_off = $l_raw_out_off - clearance - ($l_raw_out_off - $l_raw_base_off) * (clearance / $swallow_d);
    
    for($slot = [1 : $swallow_count]) translate([0, 0, ($slot - $swallow_count / 2 - 0.5) * $swallow_width])
    {
        rotate(-90, [0,1,0]) 
        linear_extrude(height=$swallow_size) 
            polygon(points=[
                [-$l_base_off,0],
                [-$l_out_off,$swallow_d - clearance],
                [$l_out_off,$swallow_d - clearance],
                [$l_base_off,0]
            ]);
        
        //cube(size=[$swallow_size,0.5,0.5], center=true);
    }
}

module screw(p1) 
{
    difference()
    {
        cube(size=[$floor, $band, $band], center=true);
        rotate(90,[0,1,0]) translate([0,0,$delta/-2]) cylinder(h=$floor + $delta,r=$screw_inside);
        
        rotate(90,[0,1,0]) translate([0,0,$floor/2-$screw_split]) cylinder(h=$floor,r=$screw_outside);
    }
}


union()
{
    translate([0, $center_width/2, 0]) swallow($swallow_clearance);
    rotate(180, [1,0,0])
    translate([0, $center_width/2, 0]) swallow($swallow_clearance);
    translate([$swallow_size / -2, 0, 0])
    difference()
    {
        cube(size=[$swallow_size, $center_width, $center_height], center=true);
        union()
        {
            // hole through the middle
        rotate(90, [0,1,0]) translate([0, 0, ($swallow_size + $delta)/-2]) cylinder(h=$swallow_size + $delta,r=$tool_inner_radius);
            
            // top screw            
            translate([$swallow_clearance, 0, 0])
            rotate(90, [0,1,0]) click_inner($swallow_clearance);            
        }
    }
    
    rotate(90, [0,1,0]) difference()
    {
        // cylinder minus rod, minus screwholes
        cylinder(h=$tool_brace_height,r=$tool_outer_radius);
        union()
        {
            translate([0,0,$delta/-2]) cylinder(h=$tool_brace_height + $delta,r=$tool_inner_radius);
            
            rotate(90, [1,0,0]) translate([0,$tool_brace_height/2,-$tool_outer_radius])
            cylinder(h=2*$tool_outer_radius + $delta,r=$tool_screw_size);
        }
    }
               
}
 