$fn=8*8;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;
$support = 0.05;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

$inset_height=4;
$inset_radius=15.5;

$center_height = 10;
$center_width = 10;
$swallow_size = 2;
$swallow_d = 0.5;
$swallow_count = 7;
$swallow_frac = 0.2;
$swallow_clearance = 0.05;

module swallow(clearance, p1)
{
    $swallow_width = $center_height/$swallow_count;
    
    // ->        <-
    //  __________
    //  \    |   /
    //   \   v  /
    // ---\    /-------
    //   ->    <-
    //       
    
    $l_raw_base_off = ($swallow_width/4) * (1-$swallow_frac);
    $l_raw_out_off = ($swallow_width/4) * (1+$swallow_frac);
    $l_base_off = $l_raw_base_off - clearance;
    $l_out_off = $l_raw_out_off - clearance - ($l_raw_out_off - $l_raw_base_off) * (clearance / $swallow_d);
    
    for($slot = [1 : $swallow_count]) translate([0, 0, ($slot - $swallow_count / 2 - 0.5) * $swallow_width])
    {
        rotate(-90, [0,1,0]) 
        linear_extrude(height=$swallow_size) 
            polygon(points=[
                [-$l_base_off,0],
                [-$l_out_off,$swallow_d - clearance],
                [$l_out_off,$swallow_d - clearance],
                [$l_base_off,0]
            ]);
        
        //cube(size=[$swallow_size,0.5,0.5], center=true);
    }
}

module screw(p1) 
{
    difference()
    {
        cube(size=[$floor, $band, $band], center=true);
        rotate(90,[0,1,0]) translate([0,0,$delta/-2]) cylinder(h=$floor + $delta,r=$screw_inside);
        
        rotate(90,[0,1,0]) translate([0,0,$floor/2-$screw_split]) cylinder(h=$floor,r=$screw_outside);
    }
}


intersection()
{  
    //union() {
                        
        // crossbars
        //translate([2, 0, 0]) cube(size=[$swallow_size,2 * tan(22.5) * $inset_radius, $center_height ], center=true);
        
        //      c_height
        //   $band
        // ---|X|-----|X|---
        //     |<- c_h / 4
        // |<-c_h / 2
        difference() {
            union() {
                // center beam
                translate([$swallow_size/-2 - $floor/2, 0, 0]) cube(size=[$swallow_size+$floor,2 * tan(22.5) * $inset_radius, $center_height/2 - $band ], center=true);
                
                // side 1
                translate([$swallow_size/-2 - $floor/2, 0, $center_height/2 - ($center_height/8 - $band/4) ]) cube(size=[$swallow_size+$floor,2 * tan(22.5) * $inset_radius, $center_height/4 - $band/2 ], center=true);
                
                // side 2
                translate([$swallow_size/-2 - $floor/2, 0, $center_height/-2 + ($center_height/8 - $band/4) ]) cube(size=[$swallow_size+$floor,2 * tan(22.5) * $inset_radius, $center_height/4 - $band/2 ], center=true);
                
                // cover completion
                translate([$floor / -2, 0, 0]) 
                    cube(size=[$floor,2 * tan(22.5) * $inset_radius, $center_height ], center=true);
    
    
        // ring screws
        translate([0, tan(22.5)*$inset_radius - $floor/2, -0.25 * $center_height]) 
          rotate(90+22.5) translate([0,$band/2,0]) screw();
        
        translate([0, -tan(22.5)*$inset_radius + $floor/2, -0.25 * $center_height]) 
          rotate(90-22.5) translate([0,$band/2,0]) screw();
          
        translate([0, tan(22.5)*$inset_radius - $floor/2, 0.25 * $center_height]) 
          rotate(90+22.5) translate([0,$band/2,0]) screw();
        
        translate([0, -tan(22.5)*$inset_radius + $floor/2, 0.25 * $center_height]) 
          rotate(90-22.5) translate([0,$band/2,0]) screw();
    
                
            }
            union()
            {
                translate([0, $center_width/2, 0]) swallow(0);
                rotate(180, [1,0,0])
                translate([0, $center_width/2, 0]) swallow(0);
                translate([$swallow_size / -2, 0, 0])
                cube(size=[$swallow_size + 2 * $floor + $delta, $center_width + 2 * $swallow_clearance, $center_height + $delta], center=true);
                
                // anticover to capture the screw oversize
                translate([$floor / 2, 0, 0]) 
                    cube(size=[$floor,2 * tan(22.5) * $inset_radius, $center_height ], center=true);
            }
        }
        
        /*
        // top joint
        translate([($inset_radius-$inside_radius) / -2,0,($center_height-$floor)/2]) cube(size=[$inset_radius-$inside_radius,$band,$floor], center=true);
        
        translate([$inside_radius-$inset_radius-$band/2, 0, 
        ($center_height-$floor)/2])
        rotate(90, [0,1,0]) screw();
        
                        
        // bottom joint
        translate([($inset_radius-$inside_radius) / -2,0,($center_height-$floor)/-2]) cube(size=[$inset_radius-$inside_radius,$band,$floor], center=true);
        
        translate([$inside_radius-$inset_radius-$band/2, 0, 
        ($center_height-$floor)/-2])
        rotate(90, [0,1,0]) screw();
        */
    
                                
    //}
           
    difference()
    {
        // cutout triangle
        translate([-$inset_radius,0,-15]) rotate(360/-16) 
            linear_extrude(height=$height+2*$inset_height+2*$center_height + $delta) polygon(points=[
        [0,0],[$outside_radius+$delta,0],[$outside_radius+$delta,$outside_radius+$delta]
    ]);    

        translate([0,-10,0]) cube(size=[15, 15, 15], center=true);                
        
    }
}

    
