//$fn=16;
$fn=8*16;

$outside_radius=19;
$inside_radius=15;
$height=6;
$delta=0.5;
$floor=0.3;
$band=2;
$support = 0.05;

$screw_inside =0.2;
$screw_outside=0.25;
$screw_split=0.05;

$inset_height=4;
$inset_radius=15.5;

$center_height = 10;
$center_width = 10;
$swallow_size = 2;
$swallow_d = 0.5;
$swallow_count = 7;
$swallow_frac = 0.2;
$swallow_clearance = 0.05;

$tool_inner_radius = 1.5;
$tool_outer_radius = 1.75;
$tool_brace_height = 2;
$tool_screw_size = 0.3;

$joint_master_radius = 2.75;
$joint_handle_radius = 1.75;
$joint_height = 1;
$joint_nook_depth = 0.2;
$joint_radius_diff = 0.25;

module click_inner(clearance, radius)
{
    difference()
    {
        cylinder(h=$joint_height,r=$joint_radius_diff+radius+clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+$delta,r=radius-clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius - $joint_nook_depth/2, $joint_height/2])  
            cube(size=[$joint_nook_depth + 2*clearance, $joint_nook_depth + 2*clearance, $joint_height], center=true);

        intersection()
        {
            difference()
            {
                cylinder(h=$joint_nook_depth,r=radius+clearance);
                
                translate([0,0,$delta/-2])    
                    cylinder(h=$joint_nook_depth + $delta,r=radius-$joint_nook_depth-clearance);                
            }       
        
            linear_extrude(height=$joint_nook_depth+$delta) polygon(points=[
                [0, 0],
                [$joint_radius_diff+radius, 0],
                [$joint_radius_diff+radius, $joint_radius_diff+radius],
            ]);
        }
    }
    
}

module click_outer(clearance, extend, radius)
{
    difference()
    {
        cylinder(h=$joint_height+extend,r=$joint_radius_diff+radius-clearance);
        translate([0,0,$delta/-2]) cylinder(h=$joint_height+extend+$delta,r=radius+clearance);
    }
    
    for ($slot = [0:4]) rotate(90 * ($slot+0.5), [0,0,1])
    {
        translate([0, radius + clearance - $joint_nook_depth/2, $joint_nook_depth/2])  
            cube(size=[$joint_nook_depth, $joint_nook_depth , $joint_nook_depth], center=true);       
    }
    
}

$handle_outside = 3.5;
$handle_outside_small = 2.2;
$handle_inside = 1.25; //(2.8 / 2) /*+ $swallow_clearance*/;
$handle_segment = 11;
$grip_ring_height = 0.25;
$grip_outset = 0.5;
$grip_inset = 0.1;
$grip_segments = 15;
$grip_cycle=0.6;

$grip_max = $handle_segment-$swallow_clearance-$joint_height+$grip_ring_height;
$grip_chunk_height = ($grip_max - $joint_height) / $grip_segments;

union()
{    
    translate([0,0,$joint_height+$handle_segment+$grip_ring_height])
        rotate(180, [0,1,0])
        click_outer($swallow_clearance, $swallow_clearance + $grip_ring_height, $joint_handle_radius);
    difference()
    {        
        union()
        {
            // core
            cylinder(h=$handle_segment-$swallow_clearance, r=$handle_outside_small-$grip_inset);
            cylinder(h=$joint_height, r=$handle_outside_small);
            translate([0,0,$grip_max])
                cylinder(h=$joint_height-$grip_ring_height, r=$handle_outside_small);
            cylinder(h=$grip_ring_height, r=$handle_outside_small + $grip_outset);
            for ($slot = [0:$grip_segments]) translate([0,0,$slot*$grip_chunk_height+$joint_height]) union()
            {
                cylinder(h=$grip_chunk_height * $grip_cycle * 0.5, r=$handle_outside_small);
                translate([0,0,$grip_chunk_height]) rotate(180, [0,1,0])
                cylinder(h=$grip_chunk_height * $grip_cycle * 0.5, r=$handle_outside_small);
            }
            
        }
            
        union()
        {
            translate(0,0,-$swallow_clearance)
            cylinder(h=$handle_segment+$swallow_clearance, r=$handle_inside);
            
            
            translate([0,0,$joint_height])
                rotate(180, [0,1,0])                
                    click_inner($swallow_clearance, $joint_handle_radius);
            
        }
    }
}
 